<?php

namespace PrimeSlider\Modules\Blog\Skins;

use PrimeSlider\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Skin_Base as Elementor_Skin_Base;

if ( !defined('ABSPATH') ) exit; // Exit if accessed directly

class Skin_Zinest extends Elementor_Skin_Base {

    public function get_id() {
        return 'zinest';
    }

    public function get_title() {
        return esc_html__('Zinest', 'bdthemes-prime-slider');
    }

    public function render_category() {
        ?>
      <span class="bdt-ps-category">
			<span><?php echo get_the_category_list(', '); ?></span>
		</span>
        <?php
    }

    public function query_posts() {
        $settings = $this->parent->get_settings();

        $args = array(
            'post_type'      => 'post',
            'posts_per_page' => 3,
            'orderby'        => $settings['orderby'],
            'order'          => $settings['order'],
            'post_status'    => 'publish'
        );

        if ( 'by_name' === $settings['post_source'] and !empty($settings['post_categories']) ) {
            $args['tax_query'][] = array(
                'taxonomy' => 'category',
                'field'    => 'slug',
                'terms'    => $settings['post_categories'],
            );
        }

        $query = new \WP_Query($args);

        return $query;
    }

    public function render_navigation_arrows() {
        $settings = $this->parent->get_settings_for_display();

        ?>

        <?php if ( $settings['show_navigation_arrows'] ) : ?>
        <div class="bdt-navigation-arrows bdt-position-bottom-right">
          <a class="bdt-prime-slider-previous" href="#" bdt-slidenav-previous bdt-slideshow-item="previous"></a>
          <a class="bdt-prime-slider-next" href="#" bdt-slidenav-next bdt-slideshow-item="next"></a>
        </div>
        <?php endif; ?>

        <?php

    }

    public function render_footer() {
        $settings = $this->parent->get_settings_for_display();
        ?>

      </ul>

        <?php $this->render_navigation_arrows(); ?>

      </div>

        <?php if ( 'yes' == $settings['show_featured_post'] ) : ?>
        <div class="bdt-ps-blog-container bdt-ps-blog-featured bdt-position-bottom">
          <div class="bdt-child-width-1-3" bdt-grid>
              <?php
              global $post;

              $wp_query = $this->parent->query_posts();

              if ( !$wp_query->found_posts ) {
                  return;
              }

              while ( $wp_query->have_posts() ) {
                  $wp_query->the_post();
                  ?>
                <div>
                  <div class="bdt-ps-featured bdt-position-relative bdt-grid bdt-flex bdt-flex-middle">
                    <!-- <div class="bdt-grid bdt-flex bdt-flex-middle"> -->
                      <div class="bdt-width-1-1 bdt-width-1-2@m">
                        <div class="bdt-ps-featured-thumbnav">
                            <?php $this->rendar_item_image(); ?>
                        </div>
                      </div>
                      <div class="bdt-width-1-1 bdt-width-1-2@m bdt-visible@m">
                        <div class="bdt-ps-content">
                          <div class="bdt-ps-title">
                            <a href="<?php echo esc_url(get_permalink($post->ID)); ?>">
                                <?php echo prime_slider_first_word(get_the_title()); ?>
                            </a>
                          </div>
                          <div class="bdt-ps-desc">
                              <?php $this->parent->render_excerpt();?>
                          </div>
                        </div>
                      </div>
                    <!-- </div> -->
                  </div>
                </div>
                  <?php
              }
              wp_reset_postdata();
              ?>
          </div>
        </div>
        <?php endif; ?>

      </div>
        <?php $this->parent->render_offcanvas(); ?>
        <?php
    }

    public function rendar_item_image() {

        $placeholder_image_src = Utils::get_placeholder_image_src();
        $image_src             = wp_get_attachment_image_src(get_post_thumbnail_id(), 'medium');

        if ( $image_src[0] ) {
            $image_src = $image_src[0];
        } else {
            $image_src = $placeholder_image_src;
        }

        ?>

      <img src="<?php echo esc_url($image_src); ?>" alt="<?php echo get_the_title(); ?>">

        <?php
    }

    public function render_item_content($post) {
        $settings = $this->parent->get_settings_for_display();

        ?>

      <div class="bdt-container">
        <div class="bdt-prime-slider-wrapper">
          <div class="bdt-prime-slider-content">
            <div class="bdt-prime-slider-desc">

                <?php if ( 'yes' == $settings['show_category'] ) : ?>
                  <div class="bdt-ps-category-wrapper" bdt-slideshow-parallax="y: 50,0,-50; opacity: 1,1,0">
                      <?php $this->render_category(); ?>
                  </div>
                <?php endif; ?>

                <?php if ('yes' == $settings['show_title']) : ?>
              <div class="bdt-main-title">
                <<?php echo Utils::get_valid_html_tag($settings['title_html_tag']); ?> class="bdt-title-tag" bdt-slideshow-parallax="y: 80,0,-80; opacity: 1,1,0">

                <a href="<?php echo esc_url(get_permalink($post->ID)); ?>">
                    <?php echo prime_slider_first_word(get_the_title()); ?>
                </a>

              </<?php echo Utils::get_valid_html_tag($settings['title_html_tag']); ?>>
            </div>
              <?php endif; ?>

              <?php if ( 'yes' == $settings['show_meta'] ) : ?>
                <?php $this->parent->render_meta(); ?>
              <?php endif; ?>

          </div>
        </div>
      </div>
      </div>

        <?php
    }

    public function render_slides_loop() {
        $settings = $this->parent->get_settings_for_display();

        $kenburns_reverse = $settings['kenburns_reverse'] ? ' bdt-animation-reverse' : '';

        $slide_index = 1;

        global $post;

        $wp_query = $this->parent->query_posts();

        if ( !$wp_query->found_posts ) {
            return;
        }

        while ( $wp_query->have_posts() ) {
            $wp_query->the_post();

            
            $placeholder_image_src = Utils::get_placeholder_image_src();
            $image_src = Group_Control_Image_Size::get_attachment_image_src(get_post_thumbnail_id(), 'thumbnail_size', $settings);
            
            if ( $image_src ) {
                $image_final_src = $image_src;
            } elseif ( $placeholder_image_src ) {
                $image_final_src = $placeholder_image_src;
            } else {
                return;
            }

            ?>

          <li class="bdt-slideshow-item bdt-flex bdt-flex-middle elementor-repeater-item-<?php echo get_the_ID(); ?>">

              <?php if ('yes' == $settings['kenburns_animation']) : ?>
            <div
                class="bdt-position-cover bdt-animation-kenburns<?php echo esc_attr($kenburns_reverse); ?> bdt-transform-origin-center-left">
                <?php endif; ?>

                <div class="bdt-ps-slide-img" style="background-image: url('<?php echo esc_url($image_final_src); ?>')"></div>

                <?php if ('yes' == $settings['kenburns_animation']) : ?>
            </div>
          <?php endif; ?>

              <?php if ( 'none' !== $settings['overlay'] ) :
                  $blend_type = ('blend' == $settings['overlay']) ? ' bdt-blend-' . $settings['blend_type'] : ''; ?>
                <div class="bdt-overlay-default bdt-position-cover<?php echo esc_attr($blend_type); ?>"></div>
              <?php endif; ?>

              <?php $this->render_item_content($post); ?>

              <?php $slide_index++; ?>

          </li>


            <?php
        }

        wp_reset_postdata();

    }

    public function render() {
        $skin_name = 'zinest';

        $this->parent->render_header($skin_name);

        $this->render_slides_loop();

        $this->render_footer();

    }
}