<?php
/**
 * This class is loaded on the back-end since its main job is 
 * to display the Admin to box.
 */

class WSSVSC_Frontend {
	
	public function __construct () {
	
		if(get_option('gmwsvs_enable_setting')=='yes'){
			if(get_option('gmwsvs_optionc')=='singlevari'){
				add_action( 'woocommerce_product_query', array( $this, 'WSSVSC_woocommerce_product_query' ) );
				add_filter( 'posts_clauses', array( $this, 'WSSVSC_posts_clauses' ), 10, 2);
			}else{
				add_filter( 'woocommerce_loop_add_to_cart_link', array( $this, 'WSSVSC_display_variation_dropdown_on_shop_page' ) , 10, 3 );
			}
			
		}
	}

	

	public function WSSVSC_display_variation_dropdown_on_shop_page($add_to_cart_html, $product, $args){
		 $gmwsvs_exclude_cat = array();
	     $gmwsvs_exclude_cat = get_option('gmwsvs_exclude_cat');
		 global $product;
		// print_r( $product);
		 $proid= $product->get_id();
		 $wwsvsc_exclude_product_single = get_post_meta( $proid, '_wwsvsc_exclude_product_single', true ); 
		 $iscatro = false;
		 $product_cat_terms = wp_get_post_terms(  $proid , 'product_cat', array("fields" => "ids"));
		/* echo "<pre>";
		 print_r($product_cat_terms);
		 echo "</pre>";*/
		 if(!empty($gmwsvs_exclude_cat)){
		 	foreach ($gmwsvs_exclude_cat as $keya => $valuea) {
		 		if (in_array($valuea, $product_cat_terms)){
		 			$iscatro = true;
		 		}
		 	}
		 }
		 if( $product->is_type( 'variable' ) && ($wwsvsc_exclude_product_single!='yes' && $iscatro == false) ) {
			
		  wp_enqueue_script('wc-add-to-cart-variation');

		  $attribute_keys = array_keys( $product->get_variation_attributes() );

		  ?>

		  <form class="variations_form cart" method="post" enctype='multipart/form-data' data-product_id="<?php echo absint( $product->id ); ?>" data-product_variations="<?php echo htmlspecialchars( json_encode( $product->get_available_variations() ) ) ?>">
		    <?php do_action( 'woocommerce_before_variations_form' ); ?>

		    <?php if ( empty( $product->get_available_variations() ) && false !== $product->get_available_variations() ) : ?>
		      <p class="stock out-of-stock">
		        <?php _e( 'This product is currently out of stock and unavailable.', 'woocommerce' ); ?>
		      </p>
		    <?php else : ?>
		      <div class="variations">
		        <div>
		          <?php foreach ( $product->get_variation_attributes() as $attribute_name => $options ) : ?>
		           
					
		            
								      <div class="single_variation_wrap">
										  <span class="value">
		              <?php
		                $selected = isset( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ? wc_clean( urldecode( $_REQUEST[ 'attribute_' . sanitize_title( $attribute_name ) ] ) ) : $product->get_variation_default_attribute( $attribute_name );
		                wc_dropdown_variation_attribute_options( array( 'options' => $options, 'attribute' => $attribute_name, 'product' => $product, 'selected' => $selected ) );
		              ?>
		        <?php
		          /**
		           * woocommerce_before_single_variation Hook.
		           */
		          do_action( 'woocommerce_before_single_variation' );

		          /**
		           * woocommerce_single_variation hook. Used to output the cart button and placeholder for variation data.
		           * @since 2.4.0
		           * @hooked woocommerce_single_variation - 10 Empty div for variation data.
		           * @hooked woocommerce_single_variation_add_to_cart_button - 20 Qty and cart button.
		           */
		          do_action( 'woocommerce_single_variation' );

		          /**
		           * woocommerce_after_single_variation Hook.
		           */
		          do_action( 'woocommerce_after_single_variation' );
		        ?>
											  </span>
		      </div>
		            
					
					<?php
			 	
			 global $product;
$proid = $product->get_id();
              $moisture = get_post_meta( $product->get_id(), 'moisture', true );
              $total_protein = get_post_meta( $product->get_id(), 'total-protein', true );
              $total_fat = get_post_meta( $product->get_id(), 'total_fat', true );
              $polyunsaturated_fatty_acids = get_post_meta( $product->get_id(), 'polyunsaturated_fatty_acids', true );
              $saturated_fatty_acids = get_post_meta( $product->get_id(), 'saturated_fatty_acids', true );
              $mono_unsaturated_fatty_acids = get_post_meta( $product->get_id(), 'mono_unsaturated_fatty_acids', true );
			 
              $trans_fatty_acids = get_post_meta( $product->get_id(), 'trans_fatty_acids', true );
              $cholesterol = get_post_meta( $product->get_id(), 'cholesterol', true );
              $total_carbohydrates = get_post_meta( $product->get_id(), 'total_carbohydrates', true );
              $dietary_fiber = get_post_meta( $product->get_id(), 'dietary_fiber', true );
              $sugar = get_post_meta( $product->get_id(), 'sugar', true );
              $iron = get_post_meta( $product->get_id(), 'iron', true );
              $sodium = get_post_meta( $product->get_id(), 'sodium', true );
              $calcium = get_post_meta( $product->get_id(), 'calcium', true );
              $calories = get_post_meta( $product->get_id(), 'calories', true );
              $vitamin_c = get_post_meta( $product->get_id(), 'vitamin_c', true );
              $vitamin_a = get_post_meta( $product->get_id(), 'vitamin_a', true );
			  $ingredient = get_post_meta( $product->get_id(), 'ingredient', true );

			  echo "<div class='nutrientBtn'id='nutrientBtn'name='Nutrient Value' value='id$proid'><img  width='45px'name='Nutrient Value' src='https://dev.leftandright.co.in/muni/wp-content/uploads/2021/06/Screenshot_2021-06-04_at_7.19.36_PM-removebg-preview.png'>  <span class='tooltiptext'>Nutrient Value</span>
</div>
			  <div class='nutrient hide'id='id$proid'>
			  <div class='nutrientHeading'>
			  <h2>NUTRITION FACTS</h2>
			  <p>Approx. per 100 gm</p>
			  </div>
			  <div class='nutrientTable'>
			  <table>
			  <tbody>
				<tr>
				  <td>Moisture</td>
				  <td>$moisture</td>
				</tr>
			  
			  
				<tr>
				  <td>Total Protein</td>
				  <td>$total_protein</td>
				</tr>
				<tr>
				  <td>Total Fat</td>
				  <td>$total_fat</td>
				</tr>
				<tr>
				  <td>Polyunsaturated Fatty Acids</td>
				  <td>$polyunsaturated_fatty_acids</td>
				</tr>
				<tr>
				  <td>Saturated Fatty Acids</td>
				  <td>$saturated_fatty_acids</td>
				</tr>
				<tr>
				  <td>Mono Unsaturated Fatty Acids</td>
				  <td>$mono_unsaturated_fatty_acids</td>
				</tr>
				<tr>
				  <td>Trans Fatty Acids</td>
				  <td>$trans_fatty_acids</td>
				</tr>
				<tr>
				  <td>Cholesterol</td>
				  <td>$cholesterol</td>
				</tr>
				<tr>
				  <td>Total Carbohydrates</td>
				  <td>$total_carbohydrates</td>
				</tr>
				<tr>
				  <td>Dietary Fiber</td>
				  <td>$dietary_fiber</td>
				</tr>
				<tr>
				  <td>Sugar</td>
				  <td>$sugar</td>
				</tr>
				<tr>
				  <td>Iron</td>
				  <td>$iron</td>
				</tr>
				<tr>
				  <td>Sodium</td>
				  <td>$sodium</td>
				</tr>
				<tr>
				  <td>Calcium</td>
				  <td>$calcium</td>
				</tr>
				<tr>
				  <td>Calories</td>
				  <td>$calories</td>
				</tr>
				<tr>
				  <td>Vitamin-C</td>
				  <td>$vitamin_c</td>
				</tr>
				<tr>
				  <td>Vitamin-A</td>
				  <td>$vitamin_a</td>
				</tr>
			  </tbody>
			  </table>  
			  </div>
			  <div class='Ingredients'>
			  <h2>Ingredients</h2>
			  <p>$ingredient</p>
			  </div>
			  </div>";
			 ?>
					
		          <?php endforeach;?>
		        </div>
		      </div>




		      <?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>
		      
		    <?php endif; ?>

		    <?php do_action( 'woocommerce_after_variations_form' ); ?>
		    
		  </form>
<img src="https://dev.leftandright.co.in/muni/wp-content/uploads/2021/06/FVE-imag.svg">
		  <?php } else { 
		 

				echo sprintf( '<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
					esc_url( $product->add_to_cart_url() ),
					esc_attr( isset( $args['quantity'] ) ? $args['quantity'] : 1 ),
					esc_attr( isset( $args['class'] ) ? $args['class'] : 'button' ),
					isset( $args['attributes'] ) ? wc_implode_html_attributes( $args['attributes'] ) : '',
					esc_html( $product->add_to_cart_text() )
				);

		  	 }
	}

	public function WSSVSC_woocommerce_product_query ($q) {

		
		$q->set( 'post_type', array('product','product_variation') );
		$q->set( 'gmwsvsfilter', 'yes' );
		$meta_query = (array) $q->get( 'meta_query' );
		$meta_query[] = array(
								'relation' => 'OR',
								array(
											'key' => '_wssvsc_excludeenalls',
											'value' => 'yes',
											'compare' => '!=',
										),
							);
	/*	$meta_query[] = array(
								'relation' => 'OR',
								array(
											'key' => '_wwsvsc_exclude_product_parent',
											'value' => 'yes',
											'compare' => 'NOT EXISTS'
										),
								array(
											'key' => '_wwsvsc_exclude_product_parent',
											'value' => 'yes',
											'compare' => '!=',
										),
							);*/
		/*echo '<pre>';
		print_r($meta_query);
		echo '</pre>';*/
		$q->set( 'meta_query', $meta_query );
		
        /*$tax_query = (array) $q->get( 'tax_query' );
        $tax_query[] = array(
            'taxonomy' => 'product_cat',
            'field'    => 'ids',
            'operator' => 'NOT IN',
            'terms'    => array( 25,28 ),
        );
		$q->set( 'tax_query', $tax_query );*/
		return $q;
	}

	public function WSSVSC_posts_clauses ($clauses, $query) {
		global $wpdb;
		if(isset($query->query_vars['gmwsvsfilter']) && $query->query_vars['gmwsvsfilter']=='yes'){
			if(get_option('gmwsvs_hide_parent_product')=='yes'){
				$clauses['where'] .= " AND  0 = (select count(*) as totalpart from {$wpdb->posts} as oc_posttb where oc_posttb.post_parent = {$wpdb->posts}.ID and oc_posttb.post_type= 'product_variation') ";
			}
			$clauses['join'] .= " LEFT JOIN {$wpdb->postmeta} as  oc_posttba ON ({$wpdb->posts}.post_parent = oc_posttba.post_id AND oc_posttba.meta_key = '_wwsvsc_exclude_product_single' )";
			$clauses['where'] .= " AND  ( oc_posttba.meta_value IS NULL OR oc_posttba.meta_value!='yes') ";
				/*echo "<pre>";
			print_r($clauses);
			echo "</pre>";*/
			$gmwsvs_exclude_cat = array();
	    	$gmwsvs_exclude_cat = get_option('gmwsvs_exclude_cat');
	    	if(!empty($gmwsvs_exclude_cat)){
	    		$clauses['where'] .= " AND ( ({$wpdb->posts}.post_type='product_variation' AND {$wpdb->posts}.ID NOT IN ( SELECT object_id FROM {$wpdb->term_relationships} WHERE term_taxonomy_id IN (".implode(",",$gmwsvs_exclude_cat).") )) OR  {$wpdb->posts}.post_type='product') ";
	    	}
			
		}
		
		return $clauses;
	}

	
	
	
}

/*add_filter( 'posts_request', 'dump_request' );

function dump_request( $input ) {

    var_dump($input);

    return $input;
}*/

?>